/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;

public class VWDataFieldItemRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_intIcon = null;
    private ImageIcon m_booleanIcon = null;
    private ImageIcon m_stringIcon = null;
    private ImageIcon m_timeIcon = null;
    private ImageIcon m_timeWarningIcon = null;
    private ImageIcon m_floatIcon = null;

    public VWDataFieldItemRenderer() {
        this.setOpaque(true);
        this.m_intIcon = VWImageLoader.createImageIcon("integer.gif");
        this.m_booleanIcon = VWImageLoader.createImageIcon("boolean.gif");
        this.m_stringIcon = VWImageLoader.createImageIcon("string.gif");
        this.m_timeIcon = VWImageLoader.createImageIcon("time.gif");
        this.m_timeWarningIcon = VWImageLoader.createImageIcon("timeWarning.gif");
        this.m_floatIcon = VWImageLoader.createImageIcon("float.gif");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list != null && value != null) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (cellHasFocus) {
                    this.setBorder(new LineBorder(SystemColor.windowBorder));
                } else {
                    this.setBorder(new LineBorder(list.getBackground()));
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(new LineBorder(list.getBackground()));
            }
            if (value instanceof VWDataFieldItem) {
                String nameString = ((VWDataFieldItem)value).toString();
                switch (((VWDataFieldItem)value).getType()) {
                    case 4: {
                        this.setIcon(this.m_booleanIcon);
                        break;
                    }
                    case 8: {
                        this.setIcon(this.m_floatIcon);
                        break;
                    }
                    case 1: {
                        this.setIcon(this.m_intIcon);
                        break;
                    }
                    case 2: {
                        this.setIcon(this.m_stringIcon);
                        nameString = nameString + " [" + ((VWDataFieldItem)value).getLength() + "]";
                        break;
                    }
                    case 16: {
                        this.setIcon(this.m_timeIcon);
                    }
                }
                this.setText(nameString);
            }
        } else {
            this.setText("");
        }
        return this;
    }
}

